<!DOCTYPE html>
<html lang="zxx">
<head>
    <meta name="title" Content="<?php echo e(__($basic->sitename)); ?>">
    <meta name="author" content="<?php echo e(url('/')); ?>" />
    <meta property="og:image:type" content="image/jpeg" />
    <meta property="og:image:width" content="590" />
    <meta property="og:image:height" content="300" />


    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title> <?php if(isset($page_title)): ?>  <?php echo e(__($page_title)); ?> | <?php endif; ?>  <?php echo e(__($basic->sitename)); ?>  </title>
    <!-- favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/logo/favicon.png')); ?>" type="image/x-icon">

    <!-- bootstrap -->
    <link rel="stylesheet" href=" <?php echo e(asset('assets/front/css/bootstrap.min.css')); ?> ">
    <!-- fontawesome icon  -->
    <link rel="stylesheet" href=" <?php echo e(asset('assets/front/css/fontawesome.min.css')); ?> ">
    <!-- animate.css -->
    <link rel="stylesheet" href=" <?php echo e(asset('assets/front/css/animate.css')); ?> ">
    <!-- Owl Carousel -->
    <link rel="stylesheet" href=" <?php echo e(asset('assets/front/css/owl.carousel.min.css')); ?> ">
    <!-- magnific popup -->
    <link rel="stylesheet" href=" <?php echo e(asset('assets/front/css/magnific-popup.css')); ?> ">
    <!-- slick css -->
    <link rel="stylesheet" href=" <?php echo e(asset('assets/front/css/slick.min.css')); ?> ">
    <!-- stylesheet -->
    <link href="<?php echo e(asset('assets/admin/css/toastr.min.css')); ?>" rel="stylesheet" />
<!-- <link rel="stylesheet" href=" <?php echo e(asset('assets/front/css/style.css')); ?> "> -->
    <link rel="stylesheet" href=" <?php echo e(asset('assets/front/css/style.php?')); ?>color=<?php echo e($basic->color); ?>&color2=<?php echo e($basic->color2); ?>">
    <!-- responsive -->
    <link rel="stylesheet" href=" <?php echo e(asset('assets/front/css/responsive.css')); ?> ">
    <!-- jquery -->
    <script src=" <?php echo e(asset('assets/front/js/jquery-3.3.1.min.js')); ?> "></script>

    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/sweetalert.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/toastr.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <?php echo $__env->yieldContent('style'); ?>

</head>

<body>
<?php echo $basic->fb_comment; ?>

<!-- preloader begin-->
<div class="preloader">
    <div class="loader">
        <hr>
        <hr>
    </div>
</div>
<!-- preloader end -->

<!-- header begin-->
<header class="header" style="background-color:cadetblue">
    <div class="container" >
        <div class="row">
            <div class="col-xl-2 col-lg-2 d-xl-flex d-lg-flex align-items-center">
                <div class="row">
                    <div class="col-6 col-xl-12 col-lg-12 d-flex d-xl-block d-lg-block align-items-center">
                        <div class="logo">
                            <a href="<?php echo e(url('/')); ?>">
                                <img src=" <?php echo e(asset('assets/images/logo/logo.png')); ?> " alt="<?php echo e($basic->sitename); ?>">
                            </a>
                        </div>
                    </div>
                    <div class="col-6 d-block d-xl-none d-lg-none">
                        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav"
                                aria-expanded="false" aria-label="Toggle navigation">
                            <i class="fas fa-bars"></i>
                        </button>
                    </div>
                </div>

            </div>
            <div class="col-xl-10 col-lg-10" >
                <div class="mainmenu">
                    <nav class="navbar navbar-expand-lg justify-content-center">
                        <div class="collapse navbar-collapse" id="navbarNav">
                            <ul class="navbar-nav nav justify-content-center">


                                    <li class="nav-item">
                                        <a class="nav-link" href="<?php echo e(route('homepage')); ?>"><?php echo app('translator')->getFromJson('Home'); ?></a>
                                    </li>
                                    <li class="nav-item"><a class="nav-link" href="<?php echo e(route('blog')); ?>"><?php echo app('translator')->getFromJson('Blog'); ?> </a></li>
                                    <li class="nav-item"><a class="nav-link" href="<?php echo e(route('about')); ?>"><?php echo app('translator')->getFromJson('About Us'); ?> </a></li>
                                    <li class="nav-item"><a class="nav-link" href="<?php echo e(route('faqs')); ?>"><?php echo app('translator')->getFromJson('Faqs'); ?> </a></li>

                                    <li class="nav-item"><a class="nav-link" href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->getFromJson('Contact'); ?> </a></li>


                                <li class="nav-item dropdown">
                                    <a class="nav-link dropdown-toggle" href="#" id="05" data-toggle="dropdown"
                                       aria-haspopup="true" aria-expanded="false">
                                        <?php echo app('translator')->getFromJson('Language'); ?>
                                    </a>
                                    <div class="dropdown-menu" aria-labelledby="05">
                                        <a class="dropdown-item" href="<?php echo e(route('lang', 'en')); ?>"><?php echo app('translator')->getFromJson('English'); ?> </a>
                                        <?php $__currentLoopData = $lan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a class="dropdown-item" href="<?php echo e(route('lang',$data->code)); ?>"><?php echo e(__($data->name)); ?></a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </li>

                                <?php if(auth()->guard()->guest()): ?>
                                    <li class="nav-item dropdown">
                                        <a class="nav-link dropdown-toggle" href="#" id="05" data-toggle="dropdown"
                                           aria-haspopup="true" aria-expanded="false">
                                            <?php echo app('translator')->getFromJson('Account'); ?>
                                        </a>
                                        <div class="dropdown-menu" aria-labelledby="05">
                                            <a class="dropdown-item" href="<?php echo e(route('login')); ?>"><?php echo app('translator')->getFromJson('Sign In'); ?> </a>
                                            <a class="dropdown-item" href="<?php echo e(route('register')); ?>"><?php echo app('translator')->getFromJson('Sign Up'); ?> </a>
                                        </div>
                                    </li>
                                <?php endif; ?>

                                <?php if(auth()->guard()->check()): ?>
                                    <li class="nav-item dropdown">
                                        <a class="nav-link dropdown-toggle" href="#" id="05" data-toggle="dropdown"
                                           aria-haspopup="true" aria-expanded="false">
                                            <?php echo app('translator')->getFromJson('Bal:'); ?> <?php echo e(number_format(Auth::user()->balance, $basic->decimal)); ?> <?php echo e($basic->currency); ?>

                                        </a>
                                        <div class="dropdown-menu" aria-labelledby="05">

                                            <a class="dropdown-item" href="<?php echo e(route('home')); ?>"><?php echo app('translator')->getFromJson('My Exchanges'); ?> </a>
                                            <a class="dropdown-item" href="<?php echo e(route('edit-profile')); ?>"><?php echo app('translator')->getFromJson('My Profile'); ?></a>
                                            <a class="dropdown-item" href="<?php echo e(route('user.change-password')); ?>"><?php echo app('translator')->getFromJson('Change Password'); ?></a>
                                            <a href="<?php echo e(route('logout')); ?>" class="dropdown-item"
                                               onclick="event.preventDefault(); document.getElementById('logout-form').submit();"><?php echo app('translator')->getFromJson('Sign Out'); ?></a>
                                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST"
                                                  style="display: none;"><?php echo e(csrf_field()); ?></form>
                                        </div>
                                    </li>
                                <?php endif; ?>






                            </ul>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</header>
<!-- header end -->

<?php echo $__env->yieldContent('content'); ?>
<?php echo $__env->make('partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<?php echo $__env->yieldContent('js'); ?>

<?php echo $basic->tawkto; ?>


<?php if(Session::has('success')): ?>
    <script type="text/javascript">
        $(document).ready(function () {
            swal("<?php echo e(__(Session::get('success'))); ?>","", "success");
        });
    </script>
<?php endif; ?>

<?php if(Session::has('warning')): ?>
    <script type="text/javascript">
        $(document).ready(function () {
            swal("<?php echo e(__(Session::get('warning'))); ?>","", "warning");
        });
    </script>
<?php endif; ?>

<?php if(Session::has('message')): ?>
<script type="text/javascript">
    var type = "<?php echo e(Session::get('alert-type','info')); ?>";
    switch (type) {
        case 'info':
            toastr.info("<?php echo e(Session::get('message')); ?>");
            break;
        case 'warning':
            toastr.warning("<?php echo e(Session::get('message')); ?>");
            break;
        case 'success':
            toastr.success("<?php echo e(Session::get('message')); ?>");
            break;
        case 'error':
            toastr.error("<?php echo e(Session::get('message')); ?>");
            break;
    }
</script>
<?php endif; ?>


</body>

</html>
